/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paperclip;

import com.destroystokyo.paperclip.PatchData;
import com.destroystokyo.paperclip.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.jbsdiff.Patch;

public class Paperclip {
    private static final File cache = new File("cache");
    private static final File customPatchInfo = new File("paperclip.json");
    private static MessageDigest digest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        URL url;
        String main;
        boolean paperValid;
        boolean vanillaValid;
        PatchData patchInfo;
        double version = Double.parseDouble(System.getProperty("java.specification.version"));
        if (version < 1.8) {
            System.err.println("Paper requires Java 8, please upgrade to it.");
            System.err.println("http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html");
            System.exit(1);
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Could not create hashing instance");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            patchInfo = customPatchInfo.exists() ? PatchData.parse(new FileInputStream(customPatchInfo)) : PatchData.parse(Paperclip.class.getResource("/patch.json").openStream());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid patch file");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (IOException e) {
            System.err.println("Error reading patch file");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        File vanillaJar = new File(cache, "mojang_" + patchInfo.getVersion() + ".jar");
        File paperJar = new File(cache, "patched_" + patchInfo.getVersion() + ".jar");
        try {
            vanillaValid = Paperclip.checkJar(vanillaJar, patchInfo.getOriginalHash());
            paperValid = Paperclip.checkJar(paperJar, patchInfo.getPatchedHash());
        }
        catch (IOException e) {
            System.err.println("Error reading jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (!paperValid) {
            byte[] patch;
            byte[] vanillaJarBytes;
            if (!vanillaValid) {
                System.out.println("Downloading original jar...");
                try {
                    FileUtils.forceMkdir(cache);
                    FileUtils.forceDelete(vanillaJar);
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    FileUtils.copyURLToFile(patchInfo.getOriginalUrl(), vanillaJar);
                }
                catch (IOException e) {
                    System.err.println("Error downloading original jar");
                    e.printStackTrace();
                    System.exit(1);
                }
                try {
                    if (!Paperclip.checkJar(vanillaJar, patchInfo.getOriginalHash())) {
                        System.err.println("Invalid original jar, quitting.");
                        System.exit(1);
                    }
                }
                catch (IOException e) {
                    System.err.println("Error reading jar");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            if (paperJar.exists()) {
                try {
                    FileUtils.forceDelete(paperJar);
                }
                catch (IOException e) {
                    System.err.println("Error deleting invalid jar");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            System.out.println("Patching original jar...");
            try {
                vanillaJarBytes = IOUtils.toByteArray(vanillaJar.toURI());
                patch = Utils.readFully(patchInfo.getPatchFile().openStream());
            }
            catch (IOException e) {
                System.err.println("Error patching original jar");
                e.printStackTrace();
                System.exit(1);
                return;
            }
            FileOutputStream jarOutput = null;
            try {
                jarOutput = new FileOutputStream(paperJar);
                Patch.patch(vanillaJarBytes, patch, jarOutput);
            }
            catch (Exception e) {
                System.err.println("Error patching origin jar");
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                if (jarOutput != null) {
                    try {
                        jarOutput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        FileInputStream fs = null;
        ZipInputStream js = null;
        try {
            fs = new FileInputStream(paperJar);
            js = new JarInputStream(fs);
            main = ((JarInputStream)js).getManifest().getMainAttributes().getValue("Main-Class");
        }
        catch (IOException e) {
            System.err.println("Error reading from patched jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (js != null) {
                try {
                    js.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            url = paperJar.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Error reading path to patched jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{url}, Paperclip.class.getClassLoader());
        try {
            Class<?> cls = Class.forName(main, true, loader);
            Method m = cls.getMethod("main", String[].class);
            Thread.currentThread().setContextClassLoader(loader);
            m.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            System.err.println("Error running patched jar");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static boolean checkJar(File jar, byte[] hash) throws IOException {
        if (jar.exists()) {
            byte[] jarBytes = IOUtils.toByteArray(jar.toURI());
            return Arrays.equals(hash, digest.digest(jarBytes));
        }
        return false;
    }
}

