/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paperclip;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class Utils {
    public static byte[] fromHex(String s) {
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Hex " + s + " must be divisible by two");
        }
        byte[] bytes = new byte[s.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            byte b;
            char left = s.charAt(i * 2);
            char right = s.charAt(i * 2 + 1);
            bytes[i] = b = (byte)(Utils.getValue(left) << 4 | Utils.getValue(right) & 0xF);
        }
        return bytes;
    }

    public static byte[] readFully(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(in, (OutputStream)out);
        return out.toByteArray();
    }

    private static int getValue(char c) {
        int i = Character.digit(c, 16);
        if (i < 0) {
            throw new IllegalArgumentException("Invalid hex char: " + c);
        }
        return i;
    }
}

