/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paperclip;

import com.destroystokyo.paperclip.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PatchData {
    private final URL patchFile;
    private final URL originalUrl;
    private final byte[] originalHash;
    private final byte[] patchedHash;

    public PatchData(JSONObject obj) {
        String patch = (String)obj.get("patch");
        URL patchFile = PatchData.class.getResource("/" + patch);
        if (new File(patch).exists()) {
            try {
                patchFile = new File(patch).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (patchFile == null) {
            throw new IllegalArgumentException("Couldn't find " + patch);
        }
        this.patchFile = patchFile;
        try {
            this.originalUrl = new URL((String)obj.get("sourceUrl"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL", e);
        }
        this.originalHash = Utils.fromHex((String)obj.get("originalHash"));
        this.patchedHash = Utils.fromHex((String)obj.get("patchedHash"));
    }

    public URL getPatchFile() {
        return this.patchFile;
    }

    public URL getOriginalUrl() {
        return this.originalUrl;
    }

    public byte[] getOriginalHash() {
        return this.originalHash;
    }

    public byte[] getPatchedHash() {
        return this.patchedHash;
    }

    public static PatchData parse(InputStream in) throws IOException {
        try {
            Object obj = new JSONParser().parse(new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8)));
            return new PatchData((JSONObject)obj);
        }
        catch (ClassCastException | ParseException e) {
            throw new IllegalArgumentException("Invalid json", e);
        }
    }
}

