/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paperclip;

import com.destroystokyo.paperclip.PatchData;
import com.destroystokyo.paperclip.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.jar.JarInputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.jbsdiff.InvalidHeaderException;
import org.jbsdiff.Patch;

class Paperclip {
    private static final File cache = new File("cache");
    private static MessageDigest digest;
    private static final File customPatchInfo;
    static File paperJar;

    Paperclip() {
    }

    static void run(String[] args) {
        String main;
        Throwable throwable;
        boolean paperValid;
        boolean vanillaValid;
        PatchData patchInfo;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Could not create hashing instance");
            e.printStackTrace();
            System.exit(1);
        }
        try (InputStream is = Paperclip.getConfig();){
            patchInfo = PatchData.parse(is);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid patch file");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (IOException e) {
            System.err.println("Error reading patch file");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        File vanillaJar = new File(cache, "mojang_" + patchInfo.getVersion() + ".jar");
        paperJar = new File(cache, "patched_" + patchInfo.getVersion() + ".jar");
        try {
            vanillaValid = Paperclip.checkJar(vanillaJar, patchInfo.getOriginalHash());
            paperValid = Paperclip.checkJar(paperJar, patchInfo.getPatchedHash());
        }
        catch (IOException e) {
            System.err.println("Error reading jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (!paperValid) {
            byte[] patch;
            byte[] vanillaJarBytes;
            Object fos;
            if (!vanillaValid) {
                System.out.println("Downloading original jar...");
                cache.mkdirs();
                vanillaJar.delete();
                try (InputStream stream = patchInfo.getOriginalUrl().openStream();){
                    ReadableByteChannel rbc = Channels.newChannel(stream);
                    fos = new FileOutputStream(vanillaJar);
                    throwable = null;
                    try {
                        ((FileOutputStream)fos).getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (fos != null) {
                            if (throwable != null) {
                                try {
                                    ((FileOutputStream)fos).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                ((FileOutputStream)fos).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    System.err.println("Error downloading original jar");
                    e.printStackTrace();
                    System.exit(1);
                }
                try {
                    if (!Paperclip.checkJar(vanillaJar, patchInfo.getOriginalHash())) {
                        System.err.println("Invalid original jar, quitting.");
                        System.exit(1);
                    }
                }
                catch (IOException e) {
                    System.err.println("Error reading jar");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            if (paperJar.exists() && !paperJar.delete()) {
                System.err.println("Error deleting invalid jar");
                System.exit(1);
            }
            System.out.println("Patching original jar...");
            try {
                vanillaJarBytes = Paperclip.getBytes(vanillaJar);
                patch = Utils.readFully(patchInfo.getPatchFile().openStream());
            }
            catch (IOException e) {
                System.err.println("Error patching original jar");
                e.printStackTrace();
                System.exit(1);
                return;
            }
            try {
                FileOutputStream jarOutput = new FileOutputStream(paperJar);
                fos = null;
                try {
                    Patch.patch(vanillaJarBytes, patch, jarOutput);
                }
                catch (Throwable throwable4) {
                    fos = throwable4;
                    throw throwable4;
                }
                finally {
                    if (jarOutput != null) {
                        if (fos != null) {
                            try {
                                jarOutput.close();
                            }
                            catch (Throwable throwable5) {
                                ((Throwable)fos).addSuppressed(throwable5);
                            }
                        } else {
                            jarOutput.close();
                        }
                    }
                }
            }
            catch (IOException | CompressorException | InvalidHeaderException e) {
                System.err.println("Error patching origin jar");
                e.printStackTrace();
                System.exit(1);
            }
        }
        if (Boolean.getBoolean("paperclip.patchonly")) {
            System.exit(0);
        }
        try (FileInputStream fs = new FileInputStream(paperJar);){
            throwable = null;
            try (JarInputStream js = new JarInputStream(fs);){
                main = js.getManifest().getMainAttributes().getValue("Main-Class");
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
        }
        catch (IOException e) {
            System.err.println("Error reading from patched jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        Utils.invoke(main, args);
    }

    private static InputStream getConfig() throws IOException {
        if (customPatchInfo.exists()) {
            return new FileInputStream(customPatchInfo);
        }
        return Paperclip.class.getResource("/patch.json").openStream();
    }

    private static byte[] getBytes(File file) throws IOException {
        byte[] b = new byte[(int)file.length()];
        try (FileInputStream fis = new FileInputStream(file);){
            if (fis.read(b) != b.length) {
                System.err.println("Error reading all the data from " + file.getAbsolutePath());
                System.exit(1);
            }
        }
        return b;
    }

    private static boolean checkJar(File jar, byte[] hash) throws IOException {
        if (jar.exists()) {
            byte[] jarBytes = Paperclip.getBytes(jar);
            return Arrays.equals(hash, digest.digest(jarBytes));
        }
        return false;
    }

    static {
        customPatchInfo = new File("paperclip.json");
    }
}

