/*
 * Decompiled with CFR 0.152.
 */
package com.destroystokyo.paperclip;

import com.destroystokyo.paperclip.PatchData;
import com.destroystokyo.paperclip.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import org.jbsdiff.Patch;

public class Paperclip {
    private static final File cache = new File("cache");
    private static final File customPatchInfo = new File("paperclip.json");
    private static MessageDigest digest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        URL url;
        String main;
        boolean paperValid;
        boolean vanillaValid;
        PatchData patchInfo;
        double version = Double.parseDouble(System.getProperty("java.specification.version"));
        if (version < 1.8) {
            System.err.println("Paper requires Java 8, please upgrade to it.");
            System.err.println("http://www.oracle.com/technetwork/java/javase/downloads/jdk8-downloads-2133151.html");
            System.exit(1);
        }
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println("Could not create hashing instance");
            e.printStackTrace();
            System.exit(1);
        }
        InputStream is = null;
        try {
            is = customPatchInfo.exists() ? new FileInputStream(customPatchInfo) : Paperclip.class.getResource("/patch.json").openStream();
            patchInfo = PatchData.parse(is);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid patch file");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        catch (IOException e) {
            System.err.println("Error reading patch file");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        File vanillaJar = new File(cache, "mojang_" + patchInfo.getVersion() + ".jar");
        File paperJar = new File(cache, "patched_" + patchInfo.getVersion() + ".jar");
        try {
            vanillaValid = Paperclip.checkJar(vanillaJar, patchInfo.getOriginalHash());
            paperValid = Paperclip.checkJar(paperJar, patchInfo.getPatchedHash());
        }
        catch (IOException e) {
            System.err.println("Error reading jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (!paperValid) {
            byte[] patch;
            byte[] vanillaJarBytes;
            if (!vanillaValid) {
                System.out.println("Downloading original jar...");
                cache.mkdirs();
                vanillaJar.delete();
                InputStream stream = null;
                FileOutputStream fos = null;
                try {
                    stream = patchInfo.getOriginalUrl().openStream();
                    ReadableByteChannel rbc = Channels.newChannel(stream);
                    fos = new FileOutputStream(vanillaJar);
                    fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                }
                catch (IOException e) {
                    System.err.println("Error downloading original jar");
                    e.printStackTrace();
                    System.exit(1);
                }
                finally {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    if (!Paperclip.checkJar(vanillaJar, patchInfo.getOriginalHash())) {
                        System.err.println("Invalid original jar, quitting.");
                        System.exit(1);
                    }
                }
                catch (IOException e) {
                    System.err.println("Error reading jar");
                    e.printStackTrace();
                    System.exit(1);
                }
            }
            if (paperJar.exists() && !paperJar.delete()) {
                System.err.println("Error deleting invalid jar");
                System.exit(1);
            }
            System.out.println("Patching original jar...");
            try {
                vanillaJarBytes = Paperclip.getBytes(vanillaJar);
                patch = Utils.readFully(patchInfo.getPatchFile().openStream());
            }
            catch (IOException e) {
                System.err.println("Error patching original jar");
                e.printStackTrace();
                System.exit(1);
                return;
            }
            FileOutputStream jarOutput = null;
            try {
                jarOutput = new FileOutputStream(paperJar);
                Patch.patch(vanillaJarBytes, patch, jarOutput);
            }
            catch (Exception e) {
                System.err.println("Error patching origin jar");
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                if (jarOutput != null) {
                    try {
                        jarOutput.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (Boolean.getBoolean("paperclip.patchonly")) {
            System.exit(0);
        }
        FileInputStream fs = null;
        ZipInputStream js = null;
        try {
            fs = new FileInputStream(paperJar);
            js = new JarInputStream(fs);
            main = ((JarInputStream)js).getManifest().getMainAttributes().getValue("Main-Class");
        }
        catch (IOException e) {
            System.err.println("Error reading from patched jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (js != null) {
                try {
                    js.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            url = paperJar.toURI().toURL();
        }
        catch (MalformedURLException e) {
            System.err.println("Error reading path to patched jar");
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (!(Paperclip.class.getClassLoader() instanceof URLClassLoader)) {
            System.err.println("SystemClassLoader not URLClassLoader");
            System.exit(1);
        }
        URLClassLoader loader = (URLClassLoader)Paperclip.class.getClassLoader();
        try {
            Method addUrl = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            addUrl.setAccessible(true);
            addUrl.invoke((Object)loader, url);
        }
        catch (Exception e) {
            System.err.println("Error adding jar to the SystemClassLoader");
            e.printStackTrace();
            System.exit(1);
        }
        try {
            Class<?> cls = Class.forName(main, true, loader);
            Method m = cls.getMethod("main", String[].class);
            m.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            System.err.println("Error running patched jar");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static byte[] getBytes(File file) throws IOException {
        byte[] b = new byte[(int)file.length()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            fis.read(b);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return b;
    }

    private static boolean checkJar(File jar, byte[] hash) throws IOException {
        if (jar.exists()) {
            byte[] jarBytes = Paperclip.getBytes(jar);
            return Arrays.equals(hash, digest.digest(jarBytes));
        }
        return false;
    }
}

